/////////////////////////////////////////////////////////////////////////////
// TreeCtrlEx.h
/////////////////////////////////////////////////////////////////////////////

#ifndef _CTREECTLEX_
#define _CTREECTLEX_

/////////////////////////////////////////////////////////////////////////////
#ifdef COMMON_EXPORTS
	#define COMMON_API __declspec(dllexport)
#else
	#define COMMON_API __declspec(dllimport)
#endif
/////////////////////////////////////////////////////////////////////////////
#pragma warning (disable : 4251)
#pragma warning (disable : 4275)
/////////////////////////////////////////////////////////////////////////////
class COMMON_API CTreeParam
{
public:
	int			mId;
	int			mLevel;
	int			mParentId;
	int			mImgId;
	HTREEITEM	mHParent;
	HTREEITEM	mHThis;
	CString		mName;
	UINT		mState;
	void*		mClassP;
	void*		mDataP;

	CTreeParam(){	mHParent = mHThis = NULL;
					mDataP = NULL;
					mId = mLevel = mParentId = -1;
					mState = 0; };
	CTreeParam(int iId, void* iClassP, void* iDataP, int iLevel, int iParentId, CString iName, int iImgId, UINT iState=0)
				{	mId = iId;
					mClassP = iClassP; mDataP = iDataP;
					mLevel = iLevel;
					mParentId = iParentId; mName = iName; mImgId = iImgId; mState = iState;};
};
/////////////////////////////////////////////////////////////////////////////
class COMMON_API CTreeCtrlEx : public CTreeCtrl
{
	DECLARE_DYNCREATE(CTreeCtrlEx)

private:
	TVINSERTSTRUCT	mTvisItem;
	CImageList*		mImageListP;
	CList<CTreeParam*,CTreeParam*>* mParamsP;

// Implementation
public:
	CTreeCtrlEx();
	virtual ~CTreeCtrlEx();
	virtual void CreateTree(CList<CTreeParam*,CTreeParam*>* iParamsListP);
	void		UpdateTreeFromTail(BOOL iDeleteTail, CTreeParam** iParamsListPP, int iCount);
	void		ParamsFree();
	HTREEITEM	GetParent(int iParenId);
	CTreeParam* GetItemParam(int iId);
	CTreeParam* GetItemParam(HTREEITEM iItem);
	CTreeParam* GetItemParam(CString iItemLabel);
	CTreeParam* GetItemSelectedParam();
	void		CreateImageList(UINT iId, int iCX, int iCY, int iFlags, int iInitial, int iGrow);
	int			ExtendImageList(HICON iIcon);
	void		SetItemSelectedId(int iId);
	int			GetItemChildCount(int iId);
	void		AddItemChilds(int iId, CTreeParam** iParamsListPP, int iCount);
	int			RemoveItemChilds(int iId);
	void		ShiftItemsId(int iId, int iCount);

// Overrides
protected:
	//{{AFX_VIRTUAL(CTreeCtrlEx)
	public:
	protected:
	//}}AFX_VIRTUAL
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif